/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

/*
 *  Represents information on a TAM. As received from the Fritzbox 
 */
public class TamInfo
{
	/*
		NewIndex  In  Int  index in list (0 <= index < count) 
		NewName  Out  String  user friendly name 
		NewEnable  Out  Boolean  is TAM enabled? 
	*/

	private int mIndex;
	private String mName;
	private boolean mEnable = false;
	private boolean mDisplay = false;

	public TamInfo(int index)
	{
		mIndex = index;
	}
	
	public int getIndex()
	{
		return mIndex;
	}
	
	public String getName()
	{
		return mName;
	}
	
	public void setName(String name)
	{
		mName = name;
	}

	public boolean isEnable()
	{
		return mEnable;
	}
	
	public void setEnable(boolean enable)
	{
		mEnable = enable;
	}

	public boolean isDisplay()
	{
		return mDisplay;
	}
	
	public void setDisplay(boolean display)
	{
		mDisplay = display;
	}
}