/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.sax;

import de.avm.android.tr064.Tr064Capabilities;

/*
 * SAX-Handler for FRITZ!Box UserInterface1 description
 */
public class SAXUserInterfaceScpdHandler extends SAXScpdHandler
{
    public boolean isCapabilitiyOfInterface(Tr064Capabilities cap)
	{
		return cap.has(Tr064Capabilities.Capability.USERINTERFACE_INFO) ||
                cap.has(Tr064Capabilities.Capability.USERINTERFACE_UPDATE);
	}
	
	/**
	 * Instantiates a new sAX FRITZ!Box UserInterface1 description handler.
	 */
	public SAXUserInterfaceScpdHandler()
	{
		initActionsArray(new String[]
		{
            // Capability.USERINTERFACE_INFO
			"GetInfo",

            // Capability.USERINTERFACE_UPDATE
            "X_AVM-DE_GetInfo",
            "X_AVM-DE_SetConfig"
		});
	}

	@Override
	public Tr064Capabilities getCapabilities()
	{
		if (mActions[0].mIsAvailable)
        {
            Tr064Capabilities result = new Tr064Capabilities(
                    Tr064Capabilities.Capability.USERINTERFACE_INFO);

            // USERINTERFACE_UPDATE
            if (mActions[1].mIsAvailable && mActions[2].mIsAvailable)
                result.add(Tr064Capabilities.Capability.WLAN_CONF_WPS);

            return result;
        }

		return Tr064Capabilities.EMPTY;
	}
}
